unit Unit1;

{ ------------------------------------------------------------------------------
    SM Software
    TXLSFile library
    Demo projects

    Autofit columns
------------------------------------------------------------------------------ }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    cbOpenAfterSave: TCheckBox;
    Panel1: TPanel;
    procedure Button1Click(Sender: TObject);
  private
    procedure RunTest;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.DFM}

uses ShellAPI
   { ---------------------------------------------------------------------------
   Use required TXLSFile library units
   --------------------------------------------------------------------------- }
   , XLSFile
   , XLSFormat;


{ Procedure uses OS shell to open and view XLS file }
procedure OpenFileInOSShell(AFile: string);
begin
  ShellExecute(0, 'open', PChar(AFile), nil, nil, SW_SHOW);
end;


procedure TForm1.RunTest;
var
  xf: TXLSFile;
begin
  Memo1.Lines.Add(FormatDateTime('dd.mm.yyyy hh:nn:ss.zzz', Now) + ' Start');

 { Create TXLSFile object.
   After creation it contains one sheet. }
  xf:= TXLSFile.Create;
  try
    { Sheets', rows', columns' indices are 0-based }

    with xf.Workbook.Sheets[0] do
    begin
      Cells[0, 1].Value:= 'Demo 1';
      Cells[0, 1].FontHeight:= 30;
      Cells[0, 2].Value:= 'Demo 2';
      Cells[0, 2].FontHeight:= 30;
      { Autofit columns 1-2 for large text }
      Columns.AutoFit(1, 2);

      Cells[0, 3].Value:= 'Text may be very long. Use an upper limit to column width.';
      { Autofit column 3 for long text.
        Set width limit to 300 pixels to prevent AutoFit from creating too wide column. }
      Columns.AutoFit(3, 3, 300);

      { This is not autofit sample, but also useful.}
      Cells[0, 4].Value:= 'Text may be very long. You may use VAlign and Width properties.';
      Cells[0, 4].FontHeight:= 20;      
      Columns[4].Width:= 300;
      { xlVAlignJustify vertical alignment wraps long text }
      Cells[0, 4].VAlign:= xlVAlignJustify;
    end;

    { Save workbook data to Excel file 'out.xls' }
    xf.SaveAs('out.xls');
  finally
    xf.Destroy;
  end;

  Memo1.Lines.Add(FormatDateTime('dd.mm.yyyy hh:nn:ss.zzz', Now) + ' done.');

  if cbOpenAfterSave.Checked then
    OpenFileInOSShell('out.xls');
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  RunTest;
end;

end.
